import React, { Component } from 'react';

class Game extends Component {
  constructor(props) {
    super(props);
    this.state = {
      targetNumber: Math.floor(Math.random() * 1000), 
      message: 'Guess a number between 0 and 999',
      guesses: 0, 
      timeLeft: 60 
    };
  }

  componentDidMount() {
    this.timer = setInterval(() => {
      if (this.state.timeLeft > 0) {
        this.setState({ timeLeft: this.state.timeLeft - 1 });
      } else {
        this.setState({ message: `Time's up! The number was ${this.state.targetNumber}` });
        clearInterval(this.timer);
      }
    }, 1000);
  }

  componentWillUnmount() {
    clearInterval(this.timer);
  }

  handleInputChange = (e) => {
    this.setState({ guess: e.target.value });
  }

  handleSubmit = (e) => {
    e.preventDefault();
    const guess = parseInt(this.state.guess);
    
    if (isNaN(guess)) {
      this.setState({ message: 'Please enter a valid number' });
      return;
    }

    this.setState({ guesses: this.state.guesses + 1 });

    if (guess === this.state.targetNumber) {
      this.setState({ message: `Correct! You guessed it in ${this.state.guesses + 1} tries!` });
      clearInterval(this.timer);
    } else if (guess < this.state.targetNumber) {
      this.setState({ message: 'Too low! Try again.' });
    } else {
      this.setState({ message: 'Too high! Try again.' });
    }

    this.setState({ guess: '' });
  }

  render() {
    return (
      <div>
        <h1>High-Low Game</h1>
        <p>DEBUG: The number is {this.state.targetNumber}</p>
        <p>Time left: {this.state.timeLeft}s</p>
        <p>Guesses: {this.state.guesses}</p>
        <p>{this.state.message}</p>
        <form onSubmit={this.handleSubmit}>
          <input
            type="number"
            value={this.state.guess}
            onChange={this.handleInputChange}
            min="0"
            max="999"
          />
          <button type="submit">Guess</button>
        </form>
      </div>
    );
  }
}

export default Game;